<?php

namespace App\Http\Controllers;

use App\Models\SurveyResponse;
use Illuminate\Http\Request;
use App\Repositories\SurveyRepository;

class SurveyController extends Controller
{
    /**
     * @var SurveyRepository
     */
    private $surveyRepo;

    /**
     * Constructor: Inyectamos el repositorio si lo requieres.
     */
    public function __construct(SurveyRepository $surveyRepo)
    {
        $this->surveyRepo = $surveyRepo;
    }

    /**
     * Muestra el formulario de la encuesta.
     */
    public function showForm()
    {
        return view('survey.form');
    }

    /**
     * Procesa y almacena las respuestas.
     * Luego redirige a /survey/scores/{id}.
     */
    public function store(Request $request)
    {
        // 1. Validar
        $validatedData = $request->validate([
            // Bloque 1
            'q1_1'  => 'nullable|integer|min:1|max:5',
            'q1_2'  => 'nullable|integer|min:1|max:5',
            'q1_3'  => 'nullable|integer|min:1|max:5',
            'q1_4'  => 'nullable|integer|min:1|max:5',
            'q1_5'  => 'nullable|integer|min:1|max:5',
            'q1_6'  => 'nullable|integer|min:1|max:5',
            'q1_7'  => 'nullable|integer|min:1|max:5',
            'q1_8'  => 'nullable|integer|min:1|max:5',
            'q1_9'  => 'nullable|integer|min:1|max:5',
            'q1_10' => 'nullable|integer|min:1|max:5',
            'q1_11' => 'nullable|integer|min:1|max:5',
            'q1_12' => 'nullable|integer|min:1|max:5',
            'q1_13' => 'nullable|integer|min:1|max:5',
            'q1_14' => 'nullable|integer|min:1|max:5',
            'q1_15' => 'nullable|integer|min:1|max:5',

            // Bloque 2
            'q2_1'  => 'nullable|integer|min:1|max:5',
            'q2_2'  => 'nullable|integer|min:1|max:5',
            'q2_3'  => 'nullable|integer|min:1|max:5',
            'q2_4'  => 'nullable|integer|min:1|max:5',
            'q2_5'  => 'nullable|integer|min:1|max:5',
            'q2_6'  => 'nullable|integer|min:1|max:5',
            'q2_7'  => 'nullable|integer|min:1|max:5',
            'q2_8'  => 'nullable|integer|min:1|max:5',
            'q2_9'  => 'nullable|integer|min:1|max:5',
            'q2_10' => 'nullable|integer|min:1|max:5',
            'q2_11' => 'nullable|integer|min:1|max:5',
            'q2_12' => 'nullable|integer|min:1|max:5',
            'q2_13' => 'nullable|integer|min:1|max:5',
            'q2_14' => 'nullable|integer|min:1|max:5',
            'q2_15' => 'nullable|integer|min:1|max:5',
            'q2_16' => 'nullable|integer|min:1|max:5',

            // Bloque 3
            'q3_1'  => 'nullable|integer|min:1|max:5',
            'q3_2'  => 'nullable|integer|min:1|max:5',
            'q3_3'  => 'nullable|integer|min:1|max:5',
            'q3_4'  => 'nullable|integer|min:1|max:5',
            'q3_5'  => 'nullable|integer|min:1|max:5',
            'q3_6'  => 'nullable|integer|min:1|max:5',
            'q3_7'  => 'nullable|integer|min:1|max:5',
            'q3_8'  => 'nullable|integer|min:1|max:5',
            'q3_9'  => 'nullable|integer|min:1|max:5',
            'q3_10' => 'nullable|integer|min:1|max:5',

            // Bloque 4
            'q4_1'  => 'nullable|integer|min:1|max:5',
            'q4_2'  => 'nullable|integer|min:1|max:5',
            'q4_3'  => 'nullable|integer|min:1|max:5',
            'q4_4'  => 'nullable|integer|min:1|max:5',
            'q4_5'  => 'nullable|integer|min:1|max:5',
            'q4_6'  => 'nullable|integer|min:1|max:5',
            'q4_7'  => 'nullable|integer|min:1|max:5',
            'q4_8'  => 'nullable|integer|min:1|max:5',
            'q4_9'  => 'nullable|integer|min:1|max:5',
            'q4_10' => 'nullable|integer|min:1|max:5',

            // Bloque 5
            'q5_1'  => 'nullable|integer|min:1|max:5',
            'q5_2'  => 'nullable|integer|min:1|max:5',
            'q5_3'  => 'nullable|integer|min:1|max:5',
            'q5_4'  => 'nullable|integer|min:1|max:5',
            'q5_5'  => 'nullable|integer|min:1|max:5',
            'q5_6'  => 'nullable|integer|min:1|max:5',
            'q5_7'  => 'nullable|integer|min:1|max:5',
            'q5_8'  => 'nullable|integer|min:1|max:5',
            'q5_9'  => 'nullable|integer|min:1|max:5',
            'q5_10' => 'nullable|integer|min:1|max:5',

            // Comentarios
            'comments' => 'nullable|string',
        ]);

        // 2. Crear la fila en la BD
        $survey = SurveyResponse::create($validatedData);

        // 3. Redireccionar a /survey/scores/{id} con un mensaje
        return redirect()
            ->route('survey.scores', $survey->id)
            ->with('status', '¡Gracias por completar la encuesta!');
    }

    /**
     * Muestra la gráfica con todos (opcional).
     * /survey/chart
     */
    public function showNormalizedChart()
    {
        // 1. Obtenemos los datos normalizados (array de stdClass).
        $scores = $this->surveyRepo->getNormalizedScores(1000);

        // Ejemplo de etiquetas generales
        $labels = ['Tecnológica', 'Pedagógica', 'Comunicativa', 'Gestión', 'Investigativa'];

        // 2. Retornamos la vista 'survey.chart'
        return view('survey.chart', compact('scores', 'labels'));
    }

    /**
     * Muestra el resultado de UN registro (id) normalizado.
     * /survey/scores/{id}
     */
    public function showScores($id)
    {
        // 1. Obtener el registro (objeto con b1_normalized, etc.)
        $row = $this->surveyRepo->getScoresById($id);
        if (!$row) {
            // Manejar error si no existe
            return redirect()->back()->with('error', 'No se encontraron puntajes para el ID ' . $id);
        }

        // 2. Tomar valores y redondear
        $tec = round($row->b1_normalized, 1);
        $ped = round($row->b2_normalized, 1);
        $com = round($row->b3_normalized, 1);
        $ges = round($row->b4_normalized, 1);
        $inv = round($row->b5_normalized, 1);

        // 3. Preparar arrays para la vista
        $labels = ["Tecnológica", "Pedagógica", "Comunicativa", "Gestión", "Investigativa"];
        $values = [$tec, $ped, $com, $ges, $inv];

        // 4. Devolver la vista con estos datos
        return view('survey.scores', compact('id', 'labels', 'values'));
    }

    /**
     * (Opcional) Método privado si la BD no normaliza y necesitas normalizar en PHP.
     */
    private function normalizar($puntaje, $min = 12, $max = 60)
    {
        return 1 + (($puntaje - $min) / ($max - $min)) * 4;
    }
}
