<?php

namespace App\Http\Controllers;

use App\Models\TeacherInfo;
use Illuminate\Http\Request;

class TeacherInfoController extends Controller
{
    /**
     * Muestra el formulario de información docente.
     */
    public function showForm()
    {
        return view('teacher.info'); 
    }

    /**
     * Procesa y guarda la información del docente, luego
     * redirige a la encuesta.
     */
    public function store(Request $request)
    {
        // 1. Validar (simplificamos, ajusta según requieras).
        $validatedData = $request->validate([
            'genero' => 'nullable|string|max:20',
            'edad' => 'nullable|integer|min:18|max:120',
            'es_normalista' => 'nullable|boolean',
            'titulo_pregrado' => 'nullable|string|max:255',
            'anio_pregrado' => 'nullable|integer',
            'realizo_posgrado' => 'nullable|boolean',
            'titulo_posgrado' => 'nullable|string|max:255',
            'anio_posgrado' => 'nullable|integer',
            'participa_eventos_tic' => 'nullable|boolean',
            'estatuto' => 'nullable|string|max:10',
            'anio_ingreso_escalafon' => 'nullable|integer',
            'tipo_vinculacion' => 'nullable|string|max:50',
            'otro_vinculacion' => 'nullable|string|max:100',
            'institucion_actual' => 'nullable|string|max:255',
            'sede' => 'nullable|string|max:255',
            'area_formacion' => 'nullable|string|max:255',
            'grados_desempena' => 'nullable|string|max:255',
        ]);

        // 2. Crear el registro
        $teacher = TeacherInfo::create($validatedData);

        // 3. Redirigir a la encuesta (por ejemplo, 'survey.show')
        return redirect()->route('survey.show') 
                         ->with('status', 'Información del docente guardada, ahora completa la encuesta.');
    }
}
