<?php

namespace App\Repositories;

use Illuminate\Support\Facades\DB;

class SurveyRepository
{
    /**
     * Devuelve el SELECT principal (sin WHERE, sin LIMIT).
     * Así evitamos repetir la lógica de sumas y normalización.
     */
    private function baseNormalizedQuery(): string
    {
        return "
            SELECT 
                id,

                -- Bloque 1 (15 preguntas)
                (
                  (
                    (q1_1 + q1_2 + q1_3 + q1_4 + q1_5
                     + q1_6 + q1_7 + q1_8 + q1_9 + q1_10
                     + q1_11 + q1_12 + q1_13 + q1_14 + q1_15)
                     - 15
                  ) * 4.0 / 60
                ) + 1 AS b1_normalized,

                -- Bloque 2 (16 preguntas)
                (
                  (
                    (q2_1 + q2_2 + q2_3 + q2_4 + q2_5
                     + q2_6 + q2_7 + q2_8 + q2_9 + q2_10
                     + q2_11 + q2_12 + q2_13 + q2_14 + q2_15 + q2_16)
                     - 16
                  ) * 4.0 / 64
                ) + 1 AS b2_normalized,

                -- Bloque 3 (10 preguntas)
                (
                  (
                    (q3_1 + q3_2 + q3_3 + q3_4 + q3_5
                     + q3_6 + q3_7 + q3_8 + q3_9 + q3_10)
                     - 10
                  ) * 4.0 / 40
                ) + 1 AS b3_normalized,

                -- Bloque 4 (10 preguntas)
                (
                  (
                    (q4_1 + q4_2 + q4_3 + q4_4 + q4_5
                     + q4_6 + q4_7 + q4_8 + q4_9 + q4_10)
                     - 10
                  ) * 4.0 / 40
                ) + 1 AS b4_normalized,

                -- Bloque 5 (10 preguntas)
                (
                  (
                    (q5_1 + q5_2 + q5_3 + q5_4 + q5_5
                     + q5_6 + q5_7 + q5_8 + q5_9 + q5_10)
                     - 10
                  ) * 4.0 / 40
                ) + 1 AS b5_normalized

            FROM survey_responses
        ";
    }

    /**
     * Retorna la normalización de todos los usuarios (hasta $limit).
     */
    public function getNormalizedScores(int $limit = 1000): array
    {
        // Usamos la consulta base y le añadimos LIMIT
        $sql = $this->baseNormalizedQuery() . " LIMIT :limit";

        return DB::select($sql, [
            'limit' => $limit,
        ]);
    }

    /**
     * Retorna la normalización de 1 usuario específico.
     */
    public function getScoresById($id)
    {
        $sql = $this->baseNormalizedQuery() . " WHERE id = :id LIMIT 1";

        return DB::selectOne($sql, [
            'id' => $id,
        ]);
    }
}
