<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTeacherInfosTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('teacher_infos', function (Blueprint $table) {
            $table->id();
            // 1. Género: "Masculino" o "Femenino"
            $table->string('genero', 20)->nullable();

            // 2. Edad
            $table->unsignedSmallInteger('edad')->nullable();

            // 3a. Es Normalista: boolean
            $table->boolean('es_normalista')->default(false);

            // 3b. Título de pregrado
            $table->string('titulo_pregrado')->nullable();
            // Año
            $table->unsignedSmallInteger('anio_pregrado')->nullable();

            // 4a. Realizó posgrado? (bool)
            $table->boolean('realizo_posgrado')->default(false);

            // 4c. Título de posgrado 1 y año
            $table->string('titulo_posgrado')->nullable();
            $table->unsignedSmallInteger('anio_posgrado')->nullable();

            // 5a. ¿Ha participado en eventos TIC?
            $table->boolean('participa_eventos_tic')->default(false);

            // 6a. Estatuto
            $table->string('estatuto', 10)->nullable(); // "2277" o "1278"

            // 7. Año de ingreso escalafón
            $table->unsignedSmallInteger('anio_ingreso_escalafon')->nullable();

            // 8. Tipo de vinculación
            $table->string('tipo_vinculacion', 50)->nullable(); 
            // 8b. Otro
            $table->string('otro_vinculacion', 100)->nullable();

            // 9a. Institución oficial 
            $table->string('institucion_actual')->nullable();
            // 9b. Sede
            $table->string('sede')->nullable();

            // 10. Área de formación actual
            $table->string('area_formacion')->nullable();

            // 11. Grados en los que se desempeña
            $table->string('grados_desempena')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('teacher_infos');
    }
}
