@extends('layouts.app')

@section('content')
<h2>Puntajes Normalizados</h2>

<!-- Canvas para la gráfica -->
<canvas id="myRadar" width="600" height="600"></canvas>

<!-- Cargar la librería de Chart.js (CDN) -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
    let scores = @json($scores);

    let labels = ['Tecnológica', 'Pedagógica', 'Comunicativa', 'Gestión', 'Investigativa'];
    let datasets = [];

    scores.forEach((row) => {
        datasets.push({
            label: "ID " + row.id,
            data: [
                row.b1_normalized,
                row.b2_normalized,
                row.b3_normalized,
                row.b4_normalized,
                row.b5_normalized
            ],
            fill: true,
            borderColor: getRandomColor(),
            backgroundColor: getRandomColor(0.2),
            borderWidth: 2,
            pointBackgroundColor: "#333"
        });
    });

    let ctx = document.getElementById('myRadar').getContext('2d');
    let myRadarChart = new Chart(ctx, {
        type: 'radar',
        data: {
            labels: labels,
            datasets: datasets
        },
        options: {
            scales: {
                r: {
                    /* Si tus valores normalizados van de 1 a 5, ajustamos min a 1 y max a 5 */
                    min: 1,
                    max: 5,
                    ticks: {
                        stepSize: 1,
                        /* callback nos permite reemplazar números por texto */
                        callback: function (value) {
                            if (value >= 1 && value <=2.9) return 'EXPLORADOR';
                            if (value === 4) return 'INTEGRADOR';
                            if (value === 5) return 'INNOVADOR';
                            return value; // Para 2 y 4, o cualquier valor intermedio, se muestra el número
                        }
                    },
                    /* pointLabels para las competencias en negrita y tamaño ~H2 */
                    pointLabels: {
                        font: {
                            size: 24,
                            weight: 'bold'
                        },
                        color: '#000'
                    }
                }
            },
            plugins: {
                legend: {
                    position: 'top'
                }
            }
        }
    });

    function getRandomColor(alpha=1) {
        const r = Math.floor(Math.random()*255);
        const g = Math.floor(Math.random()*255);
        const b = Math.floor(Math.random()*255);
        return `rgba(${r}, ${g}, ${b}, ${alpha})`;
    }
</script>
@endsection
