@extends('layouts.app')

@section('content')
    <p>
        Por favor, responde cada uno de los siguientes ítems de acuerdo con la frecuencia o nivel de dominio que consideras tener. <br>
        <strong>Escala:</strong> 
        <em>1 = Nunca</em>, 
        <em>2 = Rara vez</em>, 
        <em>3 = A veces</em>, 
        <em>4 = Frecuentemente</em>, 
        <em>5 = Siempre</em>.
    </p>
    <br>

    <form action="{{ route('survey.store') }}" method="POST">
        @csrf
        
        {{-- Bloque 1 --}}
        @include('survey.partials.block1')

        {{-- Bloque 2 --}}
        @include('survey.partials.block2')

        {{-- Bloque 3 --}}
        @include('survey.partials.block3')

        {{-- Bloque 4 --}}
        @include('survey.partials.block4')

        {{-- Bloque 5 --}}
        @include('survey.partials.block5')

        {{-- Sección de comentarios --}}
        <fieldset>
            <legend>
                <strong>
                    <h2>Comentarios finales</h2>
                </strong>
                    </legend>
            <label for="comments">
                ¿Tienes algún comentario adicional o sugerencia sobre tus necesidades de formación?
            </label>
            <br>
            <textarea name="comments" id="comments" rows="4" style="width: 100%;">{{ old('comments') }}</textarea>
        </fieldset>

        <br>
        <button type="submit">Enviar respuestas</button>
    </form>
@endsection
