{{-- resources/views/survey/scores.blade.php --}}
@extends('layouts.app')

@section('content')
    <h1>Puntajes Normalizados: Usuario ID {{ $id }}</h1>

    <p>A continuación se muestra un radar con las cinco competencias 
       (Tecnológica, Pedagógica, Comunicativa, Gestión, Investigativa) 
       normalizadas en escala 1 a 5.</p>

    <!-- Canvas para la gráfica Radar -->
    <div style="width: 600px; margin: 0 auto;">
        <canvas id="myRadar" width="600" height="600"></canvas>
    </div>

    <!-- Cargar la librería de Chart.js (desde CDN) -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <script>
        // 1. Recuperamos las variables que pasamos desde el controlador
        let etiquetas = @json($labels);  // ["Tecnológica", "Pedagógica", ...]
        let valores   = @json($values);  // [3.6, 3.8, 2.9, 3.1, 4.2] (ejemplo)

        // 2. Configuramos el Radar Chart
        let ctx = document.getElementById('myRadar').getContext('2d');
        let myRadarChart = new Chart(ctx, {
            type: 'radar',
            data: {
                labels: etiquetas,
                datasets: [{
                    label: 'Nivel de Competencia (1–5)',
                    data: valores,
                    fill: true,
                    backgroundColor: 'rgba(54, 162, 235, 0.2)', 
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 2,
                    pointBackgroundColor: 'rgba(54, 162, 235, 1)'
                }]
            },
            options: {
                scales: {
                    r: {
                        min: 0,    // inicia en 0
                        max: 5,    // escala hasta 5
                        ticks: {
                            stepSize: 1
                        }
                    }
                },
                plugins: {
                    legend: {
                        position: 'top'
                    }
                }
            }
        });
    </script>
@endsection
