@extends('layouts.app')

@section('content')
<style>
    body {
        margin: 0;
        padding: 0;
        font-family: Arial, sans-serif;
        background: #f7f9fb;
        color: #333;
    }

    main {
        max-width: 900px;
        margin: 2em auto;
        padding: 0 1em;
    }

    h1 {
        font-size: 2em;
        margin-top: 0;
        color: #2c3e50;
        text-align: center;
        margin-bottom: 1em;
    }

    form {
        background: #fff;
        border: 1px solid #ddd;
        border-radius: 5px;
        padding: 1.5em;
    }

    label {
        font-weight: bold;
    }

    input[type="text"],
    input[type="number"],
    select {
        width: 250px;
        padding: 6px;
        margin: 5px 0 10px 0;
        border: 1px solid #ccc;
        border-radius: 4px;
    }

    input[type="radio"] {
        margin-right: 5px;
    }

    button[type="submit"] {
        background: #3498db;
        color: #fff;
        padding: 0.7em 1.5em;
        border: none;
        border-radius: 4px;
        cursor: pointer;
        font-size: 1em;
        font-weight: bold;
        transition: background 0.3s;
    }

    button[type="submit"]:hover {
        background: #2980b9;
    }

    .form-group {
        margin-bottom: 1.2em;
    }

    .info-container {
        max-width: 800px;
        margin: 0 auto;
    }
</style>

<main>
    <div class="info-container">
        <h1>Información Docente</h1>

        <form action="{{ route('teacher.store') }}" method="POST">
            @csrf

            <div class="form-group">
                <label>1. Género:</label><br>
                <input type="radio" name="genero" value="Masculino"> Masculino
                <input type="radio" name="genero" value="Femenino"> Femenino
            </div>

            <div class="form-group">
                <label>2. Edad:</label>
                <input type="number" name="edad" min="18" max="120">
            </div>

            <div class="form-group">
                <label>3a. ¿Es Normalista?</label><br>
                <input type="radio" name="es_normalista" value="1"> Sí
                <input type="radio" name="es_normalista" value="0"> No
            </div>

            <div class="form-group">
                <label>3b. Título de Pregrado:</label>
                <input type="text" name="titulo_pregrado">
                <label>Año:</label>
                <input type="number" name="anio_pregrado">
            </div>

            {{-- 4a. ¿Realizó posgrado? --}}
            <div class="form-group">
                <label>4a. ¿Realizó posgrado?</label><br>
                <input type="radio" name="realizo_posgrado" value="1"> Sí
                <input type="radio" name="realizo_posgrado" value="0"> No
            </div>

            <div class="form-group">
                <label>4c. Título de posgrado 1:</label>
                <input type="text" name="titulo_posgrado">
                <label>Año:</label>
                <input type="number" name="anio_posgrado">
            </div>

            {{-- 5a. ¿Ha participado en eventos TIC? --}}
            <div class="form-group">
                <label>5a. ¿Ha participado en congresos, seminarios, etc. relacionados con TIC?</label><br>
                <input type="radio" name="participa_eventos_tic" value="1"> Sí
                <input type="radio" name="participa_eventos_tic" value="0"> No
            </div>

            <div class="form-group">
                <label>6a. Estatuto al que pertenece:</label><br>
                <select name="estatuto">
                    <option value="">-- Seleccione --</option>
                    <option value="2277">2277</option>
                    <option value="1278">1278</option>
                </select>
            </div>

            <div class="form-group">
                <label>7. Año en el que ingresó al escalafón docente:</label>
                <input type="number" name="anio_ingreso_escalafon">
            </div>

            <div class="form-group">
                <label>8. Tipo de vinculación:</label><br>
                <select name="tipo_vinculacion">
                    <option value="">-- Seleccione --</option>
                    <option value="Propiedad">Propiedad</option>
                    <option value="Provisional">Provisional</option>
                    <option value="Otro">Otro</option>
                </select>
                <br>
                <label>Cuál (solo si seleccionó Otro):</label>
                <input type="text" name="otro_vinculacion">
            </div>

            <div class="form-group">
                <label>9a. Institución oficial donde actualmente labora:</label>
                <input type="text" name="institucion_actual">
                <br>
                <label>9b. Sede:</label>
                <input type="text" name="sede">
            </div>

            <div class="form-group">
                <label>10. Área de formación actual que orienta:</label>
                <input type="text" name="area_formacion">
            </div>

            {{-- 11. Grados en los que se desempeña: lista desplegable --}}
            <div class="form-group">
                <label>11. Grados en los que se desempeña:</label><br>
                <select name="grados_desempena">
                    <option value="">-- Seleccione --</option>
                    <option value="Preescolar">Preescolar</option>
                    <option value="Basica primaria">Básica primaria</option>
                    <option value="Basica secundaria">Básica secundaria</option>
                    <option value="Media técnica">Media técnica</option>
                    <option value="Escuela nueva">Escuela nueva</option>
                    <option value="Postprimaria">Postprimaria</option>
                </select>
            </div>

            <button type="submit">Guardar y Continuar</button>
        </form>
    </div>
</main>
@endsection
