<?php

use App\Http\Controllers\TeacherInfoController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\SurveyController;

// Página de bienvenida
Route::get('/', function () {
    return view('welcome');
});
// Página de información docente
Route::get('/teacher/info', [TeacherInfoController::class, 'showForm'])->name('teacher.info');
Route::post('/teacher/info', [TeacherInfoController::class, 'store'])->name('teacher.store');

// Luego la encuesta
Route::get('/encuesta', [SurveyController::class, 'showForm'])->name('survey.show');
Route::post('/encuesta', [SurveyController::class, 'store'])->name('survey.store');


Route::get('/survey/scores/{userId}', [SurveyController::class, 'showScores'])
    ->name('survey.scores');
Route::get('/survey/chart', [SurveyController::class, 'showNormalizedChart'])
    ->name('survey.chart');

//
//    ->name('survey.scores');


// Ruta opcional para una página de "gracias" o para ver resultados, etc.
// Route::get('/encuesta/gracias', ...)->name('survey.thanks');
// Route::get('/encuesta/resultados', ...)->name('survey.results');
// Route::get('/encuesta/{id}', ...)->name('survey.showResults');
// Route::get('/encuesta/{id}/editar', ...)->name('survey.edit');
// Route::put('/encuesta/{id}', ...)->name('survey.update');
// Route::delete('/encuesta/{id}', ...)->name('survey.delete');
