<!-- resources/views/welcome.blade.php -->

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Impulsa tu Práctica Docente con las Competencias TIC</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
            background: #f7f9fb;
            color: #333;
        }

        header {
            background: linear-gradient(135deg, #5f9ea0, #4c90c7);
            color: #fff;
            padding: 2em 1em;
            text-align: center;
        }
        header h1 {
            font-size: 2.5em;
            margin: 0;
        }

        main {
            max-width: 900px;
            margin: 2em auto;
            padding: 0 1em;
        }

        h2 {
            font-size: 1.8em;
            color: #2c3e50;
            margin-top: 1.2em;
        }
        h3 {
            font-size: 1.4em;
            color: #4a4a4a;
            margin-top: 1em;
        }

        p, li {
            line-height: 1.6em;
        }

        ul {
            margin-left: 1.5em;
            margin-bottom: 1em;
        }

        .highlight {
            background: #e1f3fe;
            border-left: 4px solid #3498db;
            padding: 1em;
            margin: 1em 0;
        }

        .cta-section {
            background: #3498db;
            color: #fff;
            text-align: center;
            padding: 1.5em;
            margin-top: 2em;
            border-radius: 6px;
        }
        .cta-section p {
            margin: 0.5em 0 1em 0;
            font-size: 1.1em;
        }
        .cta-section a {
            background: #fff;
            color: #3498db;
            text-decoration: none;
            padding: 0.6em 1.2em;
            border-radius: 4px;
            font-weight: bold;
            font-size: 1em;
            transition: background 0.3s;
        }
        .cta-section a:hover {
            background: #ecf0f1;
        }

        footer {
            text-align: center;
            margin-top: 3em;
            padding: 2em 0;
            color: #999;
            font-size: 0.9em;
        }
    </style>
</head>
<body>

<header>
    <h1>Impulsa tu Práctica Docente con las Competencias TIC</h1>
</header>

<main>

    <p>
        En la era digital, las <strong>Tecnologías de la Información y Comunicación (TIC)</strong> son esenciales en la educación.
        El desarrollo profesional docente debe adaptarse a este nuevo paradigma, <em>integrando las TIC para mejorar el
        proceso de enseñanza-aprendizaje</em>. Este enfoque busca <strong>transformar las prácticas educativas</strong>, preparando
        a los docentes para los desafíos del siglo XXI.
    </p>

    <h2>¿Qué son las Competencias TIC?</h2>
    <ul>
        <li>Son el conjunto de conocimientos, habilidades y actitudes necesarias para <strong>usar las TIC de manera efectiva</strong> en la educación.</li>
        <li>Incluyen la capacidad de seleccionar, utilizar y combinar herramientas tecnológicas de forma pertinente y responsable.</li>
        <li>También implican la habilidad para <strong>comunicarse, colaborar, investigar y gestionar procesos educativos</strong> a través de las TIC.</li>
    </ul>

    <h2>Competencias Clave para el Docente del Siglo XXI</h2>
    <ul>
        <li><strong>Competencia Tecnológica:</strong> Utilizar herramientas tecnológicas de forma eficiente y responsable en el contexto educativo.</li>
        <li><strong>Competencia Comunicativa:</strong> Expresarse y relacionarse en espacios virtuales, manejando diversos lenguajes digitales.</li>
        <li><strong>Competencia Pedagógica:</strong> Integrar las TIC para fortalecer los procesos de enseñanza-aprendizaje, reconociendo sus alcances y limitaciones.</li>
        <li><strong>Competencia de Gestión:</strong> Utilizar las TIC para la planeación, organización y evaluación de procesos educativos e institucionales.</li>
        <li><strong>Competencia Investigativa:</strong> Usar las TIC para la gestión del conocimiento y la generación de nuevos saberes.</li>
    </ul>

    <h2>Niveles de Desarrollo de las Competencias TIC</h2>
    <ul>
        <li><strong>Exploración:</strong> Primer acercamiento a las TIC, descubriendo su potencial educativo.</li>
        <li><strong>Integración:</strong> Uso autónomo de las TIC para desarrollar ideas y enriquecer las prácticas pedagógicas.</li>
        <li><strong>Innovación:</strong> Creación de nuevas posibilidades de acción y explicación, transformando la práctica educativa con las TIC.</li>
    </ul>

    <div class="highlight">
        <h3>Principios para el Desarrollo Profesional Docente con TIC:</h3>
        <ul>
            <li><strong>Pertinencia:</strong> Atender las necesidades e intereses de docentes y directivos, mejorando el aprendizaje de los estudiantes.</li>
            <li><strong>Práctico:</strong> Aprender usando las TIC directamente y aplicándolas en situaciones reales.</li>
            <li><strong>Situado:</strong> Considerar los recursos y el contexto cultural de los docentes y estudiantes.</li>
            <li><strong>Colaborativo:</strong> Promover la creación colectiva y el intercambio entre pares.</li>
            <li><strong>Inspirador:</strong> Fomentar la imaginación, el pensamiento crítico y el deseo de aprender.</li>
        </ul>
    </div>

    <h2>¿Cómo impulsar el desarrollo de las Competencias TIC?</h2>
    <ul>
        <li><strong>Autoevaluación:</strong> Identificar el nivel de competencia actual en cada área.</li>
        <li><strong>Itinerarios de formación:</strong> Diseñar planes de desarrollo profesional personalizados según las necesidades e intereses de cada docente.</li>
        <li><strong>Programas de formación:</strong> Participar en cursos, talleres y seminarios que fortalezcan las competencias TIC.</li>
        <li><strong>Seguimiento:</strong> Evaluar los avances y ajustar las estrategias para un progreso continuo.</li>
    </ul>

    <h2>Beneficios de Desarrollar las Competencias TIC</h2>
    <ul>
        <li>Mejora la calidad de la enseñanza y el aprendizaje.</li>
        <li>Fortalece el desarrollo profesional docente.</li>
        <li>Promueve la innovación educativa y la transformación de las prácticas pedagógicas.</li>
        <li>Prepara a los estudiantes para los retos de la sociedad del conocimiento.</li>
        <li>Facilita la comunicación, la colaboración y la investigación.</li>
    </ul>

    <h3>¿Por qué hacerlo?</h3>
    <p>
        Desarrollar las competencias TIC es crucial para los docentes que buscan la excelencia en la educación del siglo XXI.
        La integración efectiva de las TIC en el aula <strong>transforma la manera en que se enseña y se aprende</strong>, impulsando
        el potencial de todos los estudiantes.
    </p>

    <!-- Sección CTA (Call-to-Action) -->
    <div class="cta-section">
        <h2>¿Listo para iniciar?</h2>
        <p>Descubre tu nivel de competencia TIC y fortalece tu práctica docente.</p>
        <a href="<?php echo e(route('teacher.info')); ?>">Inicia Aquí</a>
    </div>

</main>

<footer>
    &copy; <?php echo e(date('Y')); ?> - Tu Proyecto de Competencias TIC
</footer>
</body>
</html>
<?php /**PATH C:\laragon\www\encuesta-docentes\resources\views/welcome.blade.php ENDPATH**/ ?>